@extends('layouts.app')
@section('content')
<div class="content-wrapper">
	<div class="content pt-3">
		<div class="container-fluid">
			<div class="row">
				<div class="col-12">
					<div class="card border-0 shadow-custom">
						<div class="card-header border-grey">
							<h3 class="card-title">
								{{ __('reports.payment_title') }}
							</h3>
						</div>
						<div class="card-body">
							<div class="row">
								<div class="col-md-12 d-flex justify-content-between">
									<div class="report-btns">
										<a href="{{ route('reports.payment_transactions', ['type' => 'csv'] ) }}"
											class="btn btn-default">
											<i class="fas fa-file-csv"></i> {{ __('reports.export') }}
										</a>
										<a href="{{ route('reports.payment_transactions', ['type' => 'print'] ) }}"
											rel="noopener" target="_blank" class="btn btn-default">
											<i class="fas fa-print"></i> {{ __('reports.print') }}
										</a>
									</div>
									<form class="w-25" method="post"
										action="{{ route('reports.payment_transactions') }}">
										{{ csrf_field() }}
										<div class="input-group mb-3">
											<select class="form-control " name="search" required>
												<option value="all" {{ $keyword=="all" ? "selected" : "" }}>
													All
												</option>
												<option value="today" {{ $keyword=="today" ? "selected" : "" }}>
													Today
												</option>
												<option value="this_week" {{ $keyword=="this_week" ? "selected" : "" }}>
													This Week
												</option>
												<option value="this_month" {{ $keyword=="this_month" ? "selected" : ""
													}}>
													This Month
												</option>
												<option value="last_month" {{ $keyword=="last_month" ? "selected" : ""
													}}>
													Last Month
												</option>
												<option value="last_three_months" {{ $keyword=="last_three_months"
													? "selected" : "" }}>
													Last 3 Months
												</option>
												<option value="last_six_months" {{ $keyword=="last_six_months"
													? "selected" : "" }}>
													Last 6 Months
												</option>
												<option value="this_year" {{ $keyword=="this_year" ? "selected" : "" }}>
													This Year
												</option>
												<option value="last_year" {{ $keyword=="last_year" ? "selected" : "" }}>
													Last Year
												</option>
											</select>
											<div class="input-group-append">
												<button class="btn btn-primary" type="submit"><i
														class="fas fa-search"></i></button>
											</div>
										</div>
									</form>
								</div>
								<div class="col-12">
									<div class="table-responsive">
										<table class="table custom-table-bordered table-hover">
											<thead>
												<tr>
													<th class="nowrap">{{ __('reports.th_name') }}</th>
													<th>{{ __('reports.th_amount') }}</th>
													<th class="nowrap">{{ __('reports.th_payment_date') }}</th>
													<th class="nowrap">{{ __('reports.th_transaction_type') }}</th>
													<th class="nowrap">{{ __('reports.th_dr_cr') }}</th>
													<th class="nowrap">{{ __('reports.th_payment_method') }}</th>
													<th class="fixed-width-td">{{ __('reports.th_details') }}</th>
												</tr>
											</thead>
											<tbody>
												@foreach($payments as $payment)
												<tr>
													<td class="align-middle nowrap">
														{{ transaction_name($payment) }}
													</td>
													<td class="align-middle">
														{!! transaction_type($payment) !!}
													</td>
													<td class="align-middle nowrap">
														{{ format_date($payment->date) }}
													</td>
													<td class="align-middle nowrap text-capitalize">
														{{ $payment->type }}
													</td>
													<td class="align-middle nowrap text-capitalize">
														{{ $payment->dr_cr }}
													</td>
													<td class="align-middle nowrap text-capitalize">
														{{ $payment->method }}
													</td>
													<td class="align-middle nowrap">
														{{ $payment->note }}
													</td>
												</tr>
												@endforeach
												@if(count($payments) == 0)
												<tr>
													<td colspan="11">
														<p class="text-center mb-0">{{ __('reports.no_record_found') }}
														</p>
													</td>
												</tr>
												@endif
											</tbody>
										</table>
									</div>
								</div>
								<div class="col-12">
									<div class="d-flex justify-content-end">
										@if($paginate)
										{{ $payments->links() }}
										@endif
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection